/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, describe, it, expect, beforeEach, spyOn */

define(['Portal', 'backbone', 'marionette', 'jquery', 'underscore'], function (Portal, Backbone, Marionette, $, _) {
    'use strict';

    Portal.module('ListGenerator', function (ListGenerator, Portal, Backbone, Marionette, $, _) {
        ListGenerator.Patient = Backbone.Model.extend({
            defaults: {
                age: "",
                dateOfBirth: "",
                displayName: "",
                firstName: "",
                gender: "",
                inpatient: false,
                lastName: "",
                link: {},
                patientAssigningAuthority: "",
                patientId: "",
                ssn: "",
            },
            parse: function(response, options) {
                var patientItem = {},
                    patient = (response["object-type"] === "SelectedPatient") ? response.patient : response,
                    patientIdentifier = patient.patientIdentifier;

                $.extend(true, patientItem, patient, {
                    patientAssigningAuthority: patientIdentifier.assigningAuthority,
                    patientId: patientIdentifier.uniqueId
                });

                return patientItem;
            }
        });
    });
});